/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.data;

import com.google.common.cache.CacheLoader;
import journeymap.client.JourneymapClient;
import journeymap.client.data.DataCache;
import journeymap.client.log.JMLogger;
import journeymap.client.model.ChunkMD;
import journeymap.client.model.EntityDTO;
import journeymap.common.helper.BiomeHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class PlayerData
extends CacheLoader<Class, EntityDTO> {
    public static boolean playerIsUnderground(Minecraft mc, PlayerEntity player) {
        if (World.field_234919_h_.equals(player.field_70170_p.func_234923_W_())) {
            return true;
        }
        int posX = MathHelper.func_76128_c((double)player.func_226277_ct_());
        int posY = MathHelper.func_76128_c((double)player.func_174813_aQ().field_72338_b);
        int posZ = MathHelper.func_76128_c((double)player.func_226281_cx_());
        boolean offset = true;
        boolean isUnderground = false;
        if (posY < 0) {
            return true;
        }
        int y = posY;
        block0: for (int x = posX - 1; x <= posX + 1; ++x) {
            for (int z = posZ - 1; z <= posZ + 1; ++z) {
                y = posY + 1;
                ChunkMD chunkMD = DataCache.INSTANCE.getChunkMD(ChunkPos.func_77272_a((int)(x >> 4), (int)(z >> 4)));
                if (chunkMD == null) continue;
                if (chunkMD.ceiling(x & 0xF, z & 0xF) <= y) {
                    isUnderground = false;
                    break block0;
                }
                isUnderground = true;
            }
        }
        return isUnderground;
    }

    public EntityDTO load(Class aClass) throws Exception {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        EntityDTO dto = DataCache.INSTANCE.getEntityDTO((LivingEntity)player);
        dto.update((LivingEntity)player, false);
        dto.biome = this.getPlayerBiome((PlayerEntity)player);
        dto.underground = PlayerData.playerIsUnderground(mc, (PlayerEntity)player);
        return dto;
    }

    private String getPlayerBiome(PlayerEntity player) {
        if (player != null) {
            try {
                Biome biome = Minecraft.func_71410_x().field_71441_e.func_226691_t_(player.func_233580_cy_());
                if (biome != null) {
                    return BiomeHelper.getTranslatedBiomeName(biome);
                }
            }
            catch (Exception e) {
                JMLogger.logOnce("Couldn't get player biome: " + e.getMessage(), e);
            }
        }
        return "?";
    }

    public long getTTL() {
        return JourneymapClient.getInstance().getCoreProperties().cachePlayerData.get().intValue();
    }
}

