/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model;

import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Random;
import journeymap.client.Constants;
import journeymap.client.render.texture.TextureCache;
import journeymap.client.render.texture.TextureImpl;
import journeymap.client.ui.component.Button;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;

public class SplashPerson {
    public final String name;
    public final String ign;
    public final ITextComponent title;
    public Button button;
    public int width;
    public double moveX;
    public double moveY;
    private double moveDistance = 1.0;
    private Random r = new Random();

    public SplashPerson(String ign, String name, String titleKey) {
        this.ign = ign;
        this.name = name;
        this.title = titleKey != null ? Constants.getTranslatedTextComponent(titleKey) : Constants.getStringTextComponent("");
    }

    public Button getButton() {
        return this.button;
    }

    public void setButton(Button button) {
        this.button = button;
        this.randomizeVector();
    }

    public TextureImpl getSkin() {
        return TextureCache.getPlayerSkin(null, this.ign);
    }

    public int getWidth(FontRenderer fr) {
        String[] nameParts;
        this.width = fr.func_238414_a_((ITextProperties)this.title);
        for (String part : nameParts = this.name.trim().split(" ")) {
            this.width = Math.max(this.width, fr.func_78256_a(part));
        }
        return this.width;
    }

    public void setWidth(int minWidth) {
        this.width = minWidth;
    }

    public void randomizeVector() {
        this.moveDistance = this.r.nextDouble() + 0.5;
        this.moveX = this.r.nextBoolean() ? this.moveDistance : -this.moveDistance;
        this.moveDistance = this.r.nextDouble() + 0.5;
        this.moveY = this.r.nextBoolean() ? this.moveDistance : -this.moveDistance;
    }

    public void adjustVector(Rectangle2D.Double screenBounds) {
        Rectangle2D.Double buttonBounds = this.button.getBounds();
        if (!screenBounds.contains(buttonBounds)) {
            int xMargin = this.button.func_230998_h_();
            int yMargin = this.button.func_238483_d_();
            if (buttonBounds.getMinX() <= (double)xMargin) {
                this.moveX = this.moveDistance;
            } else if (buttonBounds.getMaxX() >= screenBounds.getWidth() - (double)xMargin) {
                this.moveX = -this.moveDistance;
            }
            if (buttonBounds.getMinY() <= (double)yMargin) {
                this.moveY = this.moveDistance;
            } else if (buttonBounds.getMaxY() >= screenBounds.getHeight() - (double)yMargin) {
                this.moveY = -this.moveDistance;
            }
        }
        this.continueVector();
    }

    public void continueVector() {
        this.button.setX((int)Math.round((double)this.button.field_230690_l_ + this.moveX));
        this.button.setY((int)Math.round((double)this.button.field_230691_m_ + this.moveY));
    }

    public void avoid(List<SplashPerson> others) {
        for (SplashPerson other : others) {
            if (this == other || !(this.getDistance(other) <= (double)this.button.func_230998_h_())) continue;
            this.randomizeVector();
            break;
        }
    }

    public double getDistance(SplashPerson other) {
        double px = this.button.getCenterX() - other.button.getCenterX();
        double py = this.button.getMiddleY() - other.button.getMiddleY();
        return Math.sqrt(px * px + py * py);
    }

    public static class Fake
    extends SplashPerson {
        private TextureImpl texture;

        public Fake(String name, String title, TextureImpl texture) {
            super(name, title, null);
            this.texture = texture;
        }

        @Override
        public TextureImpl getSkin() {
            return this.texture;
        }
    }
}

