/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.network;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkHooks;
import net.p3pp3rf1y.sophisticatedbackpacks.SophisticatedBackpacks;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContext;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.IContextAwareContainer;

public class BackpackOpenMessage {
    private static final int CHEST_SLOT = 38;
    private static final int OFFHAND_SLOT = 40;
    private final int slotIndex;
    private final String identifier;

    public BackpackOpenMessage() {
        this(-1);
    }

    public BackpackOpenMessage(int backpackSlot) {
        this(backpackSlot, "");
    }

    public BackpackOpenMessage(int backpackSlot, String identifier) {
        this.slotIndex = backpackSlot;
        this.identifier = identifier;
    }

    public static void encode(BackpackOpenMessage msg, PacketBuffer packetBuffer) {
        packetBuffer.writeInt(msg.slotIndex);
        packetBuffer.func_180714_a(msg.identifier);
    }

    public static BackpackOpenMessage decode(PacketBuffer packetBuffer) {
        return new BackpackOpenMessage(packetBuffer.readInt(), packetBuffer.func_218666_n());
    }

    static void onMessage(BackpackOpenMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> BackpackOpenMessage.handleMessage(context.getSender(), msg));
        context.setPacketHandled(true);
    }

    private static void handleMessage(@Nullable ServerPlayerEntity player, BackpackOpenMessage msg) {
        if (player == null) {
            return;
        }
        if (player.field_71070_bA instanceof BackpackContainer) {
            BackpackContext backpackContext = ((BackpackContainer)player.field_71070_bA).getBackpackContext();
            if (msg.slotIndex == -1) {
                BackpackOpenMessage.openBackpack(player, backpackContext.getParentBackpackContext());
            } else if (((BackpackContainer)player.field_71070_bA).isBackpackInventorySlot(msg.slotIndex)) {
                BackpackOpenMessage.openBackpack(player, backpackContext.getSubBackpackContext(msg.slotIndex));
            }
        } else if (player.field_71070_bA instanceof IContextAwareContainer) {
            BackpackContext backpackContext = ((IContextAwareContainer)player.field_71070_bA).getBackpackContext();
            BackpackOpenMessage.openBackpack(player, backpackContext);
        } else if (msg.slotIndex > -1 && player.field_71070_bA instanceof PlayerContainer) {
            int slotIndex = msg.slotIndex;
            String inventoryProvider = "main";
            if (msg.slotIndex == 38) {
                inventoryProvider = "armor";
            } else if (msg.slotIndex == 40) {
                inventoryProvider = "offhand";
                slotIndex = 0;
            }
            BackpackContext.Item backpackContext = new BackpackContext.Item(inventoryProvider, msg.identifier, slotIndex, true);
            BackpackOpenMessage.openBackpack(player, backpackContext);
        } else {
            BackpackOpenMessage.findAndOpenFirstBackpack(player);
        }
    }

    private static void findAndOpenFirstBackpack(ServerPlayerEntity player) {
        SophisticatedBackpacks.PROXY.getPlayerInventoryProvider().runOnBackpacks((PlayerEntity)player, (backpack, inventoryName, identifier, slot) -> {
            BackpackContext.Item backpackContext = new BackpackContext.Item(inventoryName, identifier, slot);
            NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new SimpleNamedContainerProvider((w, p, pl) -> new BackpackContainer(w, pl, backpackContext), backpack.func_200301_q()), backpackContext::toBuffer);
            return true;
        });
    }

    private static void openBackpack(ServerPlayerEntity player, BackpackContext backpackContext) {
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new SimpleNamedContainerProvider((w, p, pl) -> new BackpackContainer(w, pl, backpackContext), backpackContext.getDisplayName((PlayerEntity)player)), backpackContext::toBuffer);
    }
}

