/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.settings.itemdisplay;

import java.util.Optional;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.SettingsContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.SettingsContainerBase;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.itemdisplay.ItemDisplaySettingsCategory;

public class ItemDisplaySettingsContainer
extends SettingsContainerBase<ItemDisplaySettingsCategory> {
    private static final String ACTION_TAG = "action";
    private static final String COLOR_TAG = "color";
    private static final String SELECT_SLOT_TAG = "selectSlot";
    private static final String UNSELECT_SLOT_ACTION = "unselectSlot";
    private static final String ROTATE_CLOCKWISE_ACTION = "rotateClockwise";
    private static final String ROTATE_COUNTER_CLOCKWISE_ACTION = "rotateCounterClockwise";

    public ItemDisplaySettingsContainer(SettingsContainer settingsContainer, String categoryName, ItemDisplaySettingsCategory category) {
        super(settingsContainer, categoryName, category);
    }

    @Override
    public void handleMessage(CompoundNBT data) {
        if (data.func_74764_b(ACTION_TAG)) {
            switch (data.func_74779_i(ACTION_TAG)) {
                case "unselectSlot": {
                    this.unselectSlot();
                    break;
                }
                case "rotateClockwise": {
                    this.rotateClockwise();
                    break;
                }
                case "rotateCounterClockwise": {
                    this.rotateCounterClockwise();
                    break;
                }
            }
        } else if (data.func_74764_b(SELECT_SLOT_TAG)) {
            this.selectSlot(data.func_74762_e(SELECT_SLOT_TAG));
        } else if (data.func_74764_b(COLOR_TAG)) {
            this.setColor(DyeColor.func_196056_a((int)data.func_74762_e(COLOR_TAG)));
        }
    }

    public void unselectSlot(int slotNumber) {
        if (!this.isSlotSelected(slotNumber)) {
            return;
        }
        this.unselectSlot();
    }

    private void unselectSlot() {
        if (this.isServer()) {
            ((ItemDisplaySettingsCategory)this.getCategory()).unselectSlot();
        } else {
            this.sendStringToServer(ACTION_TAG, UNSELECT_SLOT_ACTION);
        }
    }

    public void selectSlot(int slotNumber) {
        if (this.isSlotSelected(slotNumber)) {
            return;
        }
        if (this.isServer()) {
            ((ItemDisplaySettingsCategory)this.getCategory()).selectSlot(slotNumber);
        } else {
            this.sendIntToServer(SELECT_SLOT_TAG, slotNumber);
        }
    }

    public void rotateClockwise() {
        if (this.isServer()) {
            ((ItemDisplaySettingsCategory)this.getCategory()).rotate(true);
        } else {
            this.sendStringToServer(ACTION_TAG, ROTATE_CLOCKWISE_ACTION);
        }
    }

    public void rotateCounterClockwise() {
        if (this.isServer()) {
            ((ItemDisplaySettingsCategory)this.getCategory()).rotate(false);
        } else {
            this.sendStringToServer(ACTION_TAG, ROTATE_COUNTER_CLOCKWISE_ACTION);
        }
    }

    public void setColor(DyeColor color) {
        if (this.isServer()) {
            ((ItemDisplaySettingsCategory)this.getCategory()).setColor(color);
        } else {
            this.sendIntToServer(COLOR_TAG, color.func_196059_a());
        }
    }

    public boolean isSlotSelected(int slotNumber) {
        return ((ItemDisplaySettingsCategory)this.getCategory()).getSlot().map(s -> s == slotNumber).orElse(false);
    }

    public DyeColor getColor() {
        return ((ItemDisplaySettingsCategory)this.getCategory()).getColor();
    }

    public int getRotation() {
        return ((ItemDisplaySettingsCategory)this.getCategory()).getRotation();
    }

    public Optional<Integer> getSlot() {
        return ((ItemDisplaySettingsCategory)this.getCategory()).getSlot();
    }
}

