/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.cooking;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.items.ItemStackHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.Config;
import net.p3pp3rf1y.sophisticatedbackpacks.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.RecipeHelper;

public class CookingLogic<T extends AbstractCookingRecipe> {
    private final ItemStack upgrade;
    private final Consumer<ItemStack> saveHandler;
    private ItemStackHandler cookingInventory = null;
    public static final int COOK_INPUT_SLOT = 0;
    public static final int COOK_OUTPUT_SLOT = 2;
    public static final int FUEL_SLOT = 1;
    @Nullable
    private T cookingRecipe = null;
    private boolean cookingRecipeInitialized = false;
    private final float burnTimeModifier;
    private final Predicate<ItemStack> isFuel;
    private final Predicate<ItemStack> isInput;
    private final double cookingSpeedMultiplier;
    private final double fuelEfficiencyMultiplier;
    private final IRecipeType<T> recipeType;
    private boolean paused = false;
    private long remainingCookTime = 0L;
    private long remainingBurnTime = 0L;

    public CookingLogic(ItemStack upgrade, Consumer<ItemStack> saveHandler, Config.Common.CookingUpgradeConfig cookingUpgradeConfig, IRecipeType<T> recipeType, float burnTimeModifier) {
        this(upgrade, saveHandler, s -> CookingLogic.getBurnTime(s, recipeType, burnTimeModifier) > 0, s -> RecipeHelper.getCookingRecipe(s, recipeType).isPresent(), cookingUpgradeConfig, recipeType, burnTimeModifier);
    }

    public CookingLogic(ItemStack upgrade, Consumer<ItemStack> saveHandler, Predicate<ItemStack> isFuel, Predicate<ItemStack> isInput, Config.Common.CookingUpgradeConfig cookingUpgradeConfig, IRecipeType<T> recipeType, float burnTimeModifier) {
        this.upgrade = upgrade;
        this.saveHandler = saveHandler;
        this.isFuel = isFuel;
        this.isInput = isInput;
        this.cookingSpeedMultiplier = (Double)cookingUpgradeConfig.cookingSpeedMultiplier.get();
        this.fuelEfficiencyMultiplier = (Double)cookingUpgradeConfig.fuelEfficiencyMultiplier.get();
        this.recipeType = recipeType;
        this.burnTimeModifier = burnTimeModifier;
    }

    private void save() {
        this.saveHandler.accept(this.upgrade);
    }

    public boolean tick(World world) {
        this.updateTimes(world);
        AtomicBoolean didSomething = new AtomicBoolean(true);
        if (this.isBurning(world) || this.readyToStartCooking()) {
            Optional<AbstractCookingRecipe> fr = this.getCookingRecipe();
            if (!fr.isPresent() && this.isCooking()) {
                this.setIsCooking(false);
            }
            fr.ifPresent(recipe -> {
                this.updateFuel(world, recipe);
                if (this.isBurning(world) && this.canSmelt((IRecipe<?>)recipe)) {
                    this.updateCookingProgress(world, recipe);
                } else if (!this.isBurning(world)) {
                    didSomething.set(false);
                }
            });
        }
        if (!this.isBurning(world) && this.isCooking()) {
            this.updateCookingCooldown(world);
        } else {
            didSomething.set(false);
        }
        return didSomething.get();
    }

    private void updateTimes(World world) {
        if (this.paused) {
            this.unpause(world);
            return;
        }
        this.remainingBurnTime = this.isBurning(world) ? this.getBurnTimeFinish() - world.func_82737_E() : 0L;
        this.remainingCookTime = this.isCooking() ? this.getCookTimeFinish() - world.func_82737_E() : 0L;
    }

    private void unpause(World world) {
        this.paused = false;
        if (this.remainingBurnTime > 0L) {
            this.setBurnTimeFinish(world.func_82737_E() + this.remainingBurnTime);
        }
        if (this.remainingCookTime > 0L) {
            this.setCookTimeFinish(world.func_82737_E() + this.remainingCookTime);
            this.setIsCooking(true);
        }
    }

    public boolean isBurning(World world) {
        return this.getBurnTimeFinish() >= world.func_82737_E();
    }

    private Optional<T> getCookingRecipe() {
        if (!this.cookingRecipeInitialized) {
            this.cookingRecipe = RecipeHelper.getCookingRecipe(this.getCookInput(), this.recipeType).orElse(null);
            this.cookingRecipeInitialized = true;
        }
        return Optional.ofNullable(this.cookingRecipe);
    }

    private void updateCookingCooldown(World world) {
        if (this.getRemainingCookTime(world) + 2 > this.getCookTimeTotal()) {
            this.setIsCooking(false);
        } else {
            this.setCookTimeFinish(world.func_82737_E() + (long)Math.min(this.getRemainingCookTime(world) + 2, this.getCookTimeTotal()));
        }
    }

    private void updateCookingProgress(World world, T cookingRecipe) {
        if (this.isCooking() && this.finishedCooking(world)) {
            this.smelt((IRecipe<?>)cookingRecipe);
            if (this.canSmelt((IRecipe<?>)cookingRecipe)) {
                this.setCookTime(world, (int)((double)cookingRecipe.func_222137_e() * (1.0 / this.cookingSpeedMultiplier)));
            } else {
                this.setIsCooking(false);
            }
        } else if (!this.isCooking()) {
            this.setIsCooking(true);
            this.setCookTime(world, (int)((double)cookingRecipe.func_222137_e() * (1.0 / this.cookingSpeedMultiplier)));
        }
    }

    private boolean finishedCooking(World world) {
        return this.getCookTimeFinish() <= world.func_82737_E();
    }

    private boolean readyToStartCooking() {
        return !this.getFuel().func_190926_b() && !this.getCookInput().func_190926_b();
    }

    private void smelt(IRecipe<?> recipe) {
        if (!this.canSmelt(recipe)) {
            return;
        }
        ItemStack input = this.getCookInput();
        ItemStack recipeOutput = recipe.func_77571_b();
        ItemStack output = this.getCookOutput();
        if (output.func_190926_b()) {
            this.setCookOutput(recipeOutput.func_77946_l());
        } else if (output.func_77973_b() == recipeOutput.func_77973_b()) {
            output.func_190917_f(recipeOutput.func_190916_E());
            this.setCookOutput(output);
        }
        if (input.func_77973_b() == Blocks.field_196577_ad.func_199767_j() && !this.getFuel().func_190926_b() && this.getFuel().func_77973_b() == Items.field_151133_ar) {
            this.setFuel(new ItemStack((IItemProvider)Items.field_151131_as));
        }
        input.func_190918_g(1);
        this.setCookInput(input);
    }

    public void setCookInput(ItemStack input) {
        this.cookingInventory.setStackInSlot(0, input);
    }

    private void setCookOutput(ItemStack stack) {
        this.getCookingInventory().setStackInSlot(2, stack);
    }

    private int getRemainingCookTime(World world) {
        return (int)(this.getCookTimeFinish() - world.func_82737_E());
    }

    private void setCookTime(World world, int cookTime) {
        this.setCookTimeFinish(world.func_82737_E() + (long)cookTime);
        this.setCookTimeTotal(cookTime);
    }

    public void pause() {
        this.paused = true;
        this.setCookTimeFinish(0L);
        this.setIsCooking(false);
        this.setBurnTimeFinish(0L);
    }

    private void updateFuel(World world, T cookingRecipe) {
        ItemStack fuel = this.getFuel();
        if (!this.isBurning(world) && this.canSmelt((IRecipe<?>)cookingRecipe)) {
            if (CookingLogic.getBurnTime(fuel, this.recipeType, this.burnTimeModifier) <= 0) {
                return;
            }
            this.setBurnTime(world, (int)((double)CookingLogic.getBurnTime(fuel, this.recipeType, this.burnTimeModifier) * this.fuelEfficiencyMultiplier / this.cookingSpeedMultiplier));
            if (this.isBurning(world)) {
                if (fuel.hasContainerItem()) {
                    this.setFuel(fuel.getContainerItem());
                } else if (!fuel.func_190926_b()) {
                    fuel.func_190918_g(1);
                    this.setFuel(fuel);
                    if (fuel.func_190926_b()) {
                        this.setFuel(fuel.getContainerItem());
                    }
                }
            }
        }
    }

    private void setBurnTime(World world, int burnTime) {
        this.setBurnTimeFinish(world.func_82737_E() + (long)burnTime);
        this.setBurnTimeTotal(burnTime);
    }

    protected boolean canSmelt(IRecipe<?> cookingRecipe) {
        if (this.getCookInput().func_190926_b()) {
            return false;
        }
        ItemStack recipeOutput = cookingRecipe.func_77571_b();
        if (recipeOutput.func_190926_b()) {
            return false;
        }
        ItemStack output = this.getCookOutput();
        if (output.func_190926_b()) {
            return true;
        }
        if (!output.func_77969_a(recipeOutput)) {
            return false;
        }
        if (output.func_190916_E() + recipeOutput.func_190916_E() <= 64 && output.func_190916_E() + recipeOutput.func_190916_E() <= output.func_77976_d()) {
            return true;
        }
        return output.func_190916_E() + recipeOutput.func_190916_E() <= recipeOutput.func_77976_d();
    }

    private static <T extends AbstractCookingRecipe> int getBurnTime(ItemStack fuel, IRecipeType<T> recipeType, float burnTimeModifier) {
        return (int)((float)ForgeHooks.getBurnTime((ItemStack)fuel, recipeType) * burnTimeModifier);
    }

    public ItemStack getCookOutput() {
        return this.getCookingInventory().getStackInSlot(2);
    }

    public ItemStack getCookInput() {
        return this.getCookingInventory().getStackInSlot(0);
    }

    public ItemStack getFuel() {
        return this.getCookingInventory().getStackInSlot(1);
    }

    public void setFuel(ItemStack fuel) {
        this.getCookingInventory().setStackInSlot(1, fuel);
    }

    public ItemStackHandler getCookingInventory() {
        if (this.cookingInventory == null) {
            this.cookingInventory = new ItemStackHandler(3){

                protected void onContentsChanged(int slot) {
                    super.onContentsChanged(slot);
                    CookingLogic.this.upgrade.func_77983_a("cookingInventory", (INBT)this.serializeNBT());
                    CookingLogic.this.save();
                    if (slot == 0) {
                        CookingLogic.this.cookingRecipeInitialized = false;
                    }
                }

                public boolean isItemValid(int slot, ItemStack stack) {
                    switch (slot) {
                        case 0: {
                            return CookingLogic.this.isInput.test(stack);
                        }
                        case 1: {
                            return CookingLogic.this.isFuel.test(stack);
                        }
                    }
                    return true;
                }
            };
            Optional<CompoundNBT> smeltingInventory = NBTHelper.getCompound(this.upgrade, "smeltingInventory");
            if (smeltingInventory.isPresent()) {
                this.cookingInventory.deserializeNBT(smeltingInventory.get());
            } else {
                NBTHelper.getCompound(this.upgrade, "cookingInventory").ifPresent(arg_0 -> ((ItemStackHandler)this.cookingInventory).deserializeNBT(arg_0));
            }
        }
        return this.cookingInventory;
    }

    public long getBurnTimeFinish() {
        return NBTHelper.getLong(this.upgrade, "burnTimeFinish").orElse(0L);
    }

    private void setBurnTimeFinish(long burnTimeFinish) {
        NBTHelper.setLong(this.upgrade, "burnTimeFinish", burnTimeFinish);
        this.save();
    }

    public int getBurnTimeTotal() {
        return NBTHelper.getInt(this.upgrade, "burnTimeTotal").orElse(0);
    }

    private void setBurnTimeTotal(int burnTimeTotal) {
        NBTHelper.setInteger(this.upgrade, "burnTimeTotal", burnTimeTotal);
        this.save();
    }

    public long getCookTimeFinish() {
        return NBTHelper.getLong(this.upgrade, "cookTimeFinish").orElse(-1L);
    }

    private void setCookTimeFinish(long cookTimeFinish) {
        NBTHelper.setLong(this.upgrade, "cookTimeFinish", cookTimeFinish);
        this.save();
    }

    public int getCookTimeTotal() {
        return NBTHelper.getInt(this.upgrade, "cookTimeTotal").orElse(0);
    }

    private void setCookTimeTotal(int cookTimeTotal) {
        NBTHelper.setInteger(this.upgrade, "cookTimeTotal", cookTimeTotal);
        this.save();
    }

    public boolean isCooking() {
        return NBTHelper.getBoolean(this.upgrade, "isCooking").orElse(false);
    }

    private void setIsCooking(boolean isCooking) {
        NBTHelper.setBoolean(this.upgrade, "isCooking", isCooking);
        this.save();
    }
}

