/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.xppump;

import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.Config;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackFluidHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModFluids;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.xppump.AutomationDirection;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.xppump.XpPumpUpgradeItem;
import net.p3pp3rf1y.sophisticatedbackpacks.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.XpHelper;

public class XpPumpUpgradeWrapper
extends UpgradeWrapperBase<XpPumpUpgradeWrapper, XpPumpUpgradeItem>
implements ITickableUpgrade {
    private static final int DEFAULT_LEVEL = 10;
    private static final int COOLDOWN = 5;
    private static final int ALL_LEVELS = 10000;
    private static final int PLAYER_SEARCH_RANGE = 3;

    protected XpPumpUpgradeWrapper(IBackpackWrapper backpackWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(backpackWrapper, upgrade, upgradeSaveHandler);
    }

    @Override
    public void tick(@Nullable LivingEntity entity, World world, BlockPos pos) {
        if (entity != null && !(entity instanceof PlayerEntity) || this.isInCooldown(world)) {
            return;
        }
        if (entity == null) {
            AxisAlignedBB searchBox = new AxisAlignedBB(pos).func_186662_g(3.0);
            for (PlayerEntity player : world.func_217369_A()) {
                if (!searchBox.func_197744_e(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_())) continue;
                this.interactWithPlayer(player);
                this.mendItems(player);
            }
        } else {
            PlayerEntity player = (PlayerEntity)entity;
            this.interactWithPlayer(player);
            this.mendItems(player);
        }
        this.setCooldown(world, 5);
    }

    private void mendItems(PlayerEntity player) {
        float xpToTryDrain;
        ItemStack itemStack;
        if (Boolean.FALSE.equals(Config.COMMON.xpPumpUpgrade.mendingOn.get()) || !this.shouldMendItems()) {
            return;
        }
        Map.Entry entry = EnchantmentHelper.func_234844_a_((Enchantment)Enchantments.field_185296_A, (LivingEntity)player, ItemStack::func_77951_h);
        if (entry != null && !(itemStack = (ItemStack)entry.getValue()).func_190926_b() && itemStack.func_77951_h() && itemStack.getXpRepairRatio() > 0.0f && (xpToTryDrain = Math.min((float)((Integer)Config.COMMON.xpPumpUpgrade.maxXpPointsPerMending.get()).intValue(), (float)itemStack.func_77952_i() / itemStack.getXpRepairRatio())) > 0.0f) {
            this.backpackWrapper.getFluidHandler().ifPresent(fluidHandler -> {
                FluidStack drained = fluidHandler.drain((ITag<Fluid>)ModFluids.EXPERIENCE_TAG, XpHelper.experienceToLiquid(xpToTryDrain), IFluidHandler.FluidAction.EXECUTE, false);
                float xpDrained = XpHelper.liquidToExperience(drained.getAmount());
                int durationToRepair = (int)(xpDrained * itemStack.getXpRepairRatio());
                itemStack.func_196085_b(itemStack.func_77952_i() - durationToRepair);
            });
        }
    }

    private void interactWithPlayer(PlayerEntity player) {
        this.backpackWrapper.getFluidHandler().ifPresent(fluidHandler -> {
            int level = this.getLevel();
            AutomationDirection direction = this.getDirection();
            if (direction == AutomationDirection.OFF) {
                return;
            }
            if (direction == AutomationDirection.INPUT) {
                if (level < player.field_71068_ca || level == player.field_71068_ca && player.field_71106_cc > 0.0f) {
                    this.tryFillTankWithPlayerExperience(player, (IBackpackFluidHandler)fluidHandler, level, false);
                }
            } else if (direction == AutomationDirection.OUTPUT && level > player.field_71068_ca) {
                this.tryGivePlayerExperienceFromTank(player, (IBackpackFluidHandler)fluidHandler, level, false);
            }
        });
    }

    private void tryGivePlayerExperienceFromTank(PlayerEntity player, IBackpackFluidHandler fluidHandler, int stopAtLevel) {
        this.tryGivePlayerExperienceFromTank(player, fluidHandler, stopAtLevel, true);
    }

    private void tryGivePlayerExperienceFromTank(PlayerEntity player, IBackpackFluidHandler fluidHandler, int stopAtLevel, boolean ignoreInOutLimit) {
        int maxXpPointsToGive = XpHelper.getExperienceForLevel(stopAtLevel) - XpHelper.getPlayerTotalExperience(player);
        FluidStack drained = fluidHandler.drain((ITag<Fluid>)ModFluids.EXPERIENCE_TAG, XpHelper.experienceToLiquid(maxXpPointsToGive), IFluidHandler.FluidAction.EXECUTE, ignoreInOutLimit);
        if (!drained.isEmpty()) {
            player.func_195068_e((int)XpHelper.liquidToExperience(drained.getAmount()));
        }
    }

    private void tryFillTankWithPlayerExperience(PlayerEntity player, IBackpackFluidHandler fluidHandler, int stopAtLevel) {
        this.tryFillTankWithPlayerExperience(player, fluidHandler, stopAtLevel, true);
    }

    private void tryFillTankWithPlayerExperience(PlayerEntity player, IBackpackFluidHandler fluidHandler, int stopAtLevel, boolean ignoreInOutLimit) {
        int maxXpPointsToTake = XpHelper.getPlayerTotalExperience(player) - XpHelper.getExperienceForLevel(stopAtLevel);
        int filled = fluidHandler.fill((ITag<Fluid>)ModFluids.EXPERIENCE_TAG, XpHelper.experienceToLiquid(maxXpPointsToTake), (Fluid)ModFluids.XP_STILL.get(), IFluidHandler.FluidAction.EXECUTE, ignoreInOutLimit);
        if (filled > 0) {
            player.func_195068_e((int)(-XpHelper.liquidToExperience(filled)));
        }
    }

    public void takeLevelsFromPlayer(PlayerEntity player) {
        this.backpackWrapper.getFluidHandler().ifPresent(fluidHandler -> this.tryFillTankWithPlayerExperience(player, (IBackpackFluidHandler)fluidHandler, Math.max(player.field_71068_ca - this.getLevelsToStore(), 0)));
    }

    public void takeAllExperienceFromPlayer(PlayerEntity player) {
        this.backpackWrapper.getFluidHandler().ifPresent(fluidHandler -> this.tryFillTankWithPlayerExperience(player, (IBackpackFluidHandler)fluidHandler, 0));
    }

    public void giveLevelsToPlayer(PlayerEntity player) {
        this.backpackWrapper.getFluidHandler().ifPresent(fluidHandler -> this.tryGivePlayerExperienceFromTank(player, (IBackpackFluidHandler)fluidHandler, player.field_71068_ca + this.getLevelsToTake()));
    }

    public void giveAllExperienceToPlayer(PlayerEntity player) {
        this.backpackWrapper.getFluidHandler().ifPresent(fluidHandler -> this.tryGivePlayerExperienceFromTank(player, (IBackpackFluidHandler)fluidHandler, 10000));
    }

    public AutomationDirection getDirection() {
        return NBTHelper.getEnumConstant(this.upgrade, "direction", AutomationDirection::fromName).orElse(AutomationDirection.INPUT);
    }

    public void setDirection(AutomationDirection direction) {
        NBTHelper.setEnumConstant(this.upgrade, "direction", direction);
        this.save();
    }

    public void setLevel(int level) {
        NBTHelper.setInteger(this.upgrade, "level", level);
        this.save();
    }

    public int getLevel() {
        return NBTHelper.getInt(this.upgrade, "level").orElse(10);
    }

    public void setLevelsToStore(int levelsToTake) {
        NBTHelper.setInteger(this.upgrade, "levelsToStore", levelsToTake);
        this.save();
    }

    public int getLevelsToStore() {
        return NBTHelper.getInt(this.upgrade, "levelsToStore").orElse(1);
    }

    public void setLevelsToTake(int levelsToGive) {
        NBTHelper.setInteger(this.upgrade, "levelsToTake", levelsToGive);
        this.save();
    }

    public int getLevelsToTake() {
        return NBTHelper.getInt(this.upgrade, "levelsToTake").orElse(1);
    }

    public boolean shouldMendItems() {
        return NBTHelper.getBoolean(this.upgrade, "mendItems").orElse(true);
    }

    public void setMendItems(boolean mendItems) {
        NBTHelper.setBoolean(this.upgrade, "mendItems", mendItems);
        this.save();
    }
}

