/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.util;

import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IItemHandlerInteractionUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.util.WorldHelper;

public class InventoryInteractionHelper {
    private InventoryInteractionHelper() {
    }

    public static boolean tryInventoryInteraction(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        if (player == null) {
            return false;
        }
        return InventoryInteractionHelper.tryInventoryInteraction(context.func_195995_a(), context.func_195991_k(), context.func_195996_i(), context.func_196000_l(), player);
    }

    public static boolean tryInventoryInteraction(BlockPos pos, World world, ItemStack backpack, Direction face, PlayerEntity player) {
        return WorldHelper.getTile((IBlockReader)world, pos).map(te -> te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face).map(itemHandler -> player.field_70170_p.field_72995_K || backpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).map(wrapper -> InventoryInteractionHelper.tryRunningInteractionWrappers(itemHandler, wrapper, player)).orElse(false) != false).orElse(false)).orElse(false);
    }

    private static boolean tryRunningInteractionWrappers(IItemHandler itemHandler, IBackpackWrapper wrapper, PlayerEntity player) {
        List<IItemHandlerInteractionUpgrade> wrappers = wrapper.getUpgradeHandler().getWrappersThatImplement(IItemHandlerInteractionUpgrade.class);
        if (wrappers.isEmpty()) {
            return false;
        }
        wrappers.forEach(upgrade -> upgrade.onHandlerInteract(itemHandler, player));
        return true;
    }
}

